<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

/*
 *  Create theme options
 */

$clinox_theme_option = 'clinox_theme_options';

// Create options
CSF::createOptions( $clinox_theme_option, array(
	'framework_title' => wp_kses(
		sprintf(__("Clinox Options <small>V %s</small>", 'clinox'), $clinox_theme_data->get('Version')),
		array('small' => array())
	),
	'menu_title'      => __('Theme Options','clinox'),
	'menu_slug'       => 'clinox-options',
	'show_sub_menu'   => false,
	'class'           => 'clinox-theme-option',
	'menu_position'   =>3,
	'footer_credit'   => wp_kses(
		__( 'Developed by: <a target="_blank" href="https://themexriver.com">ThemeXriver</a>', 'clinox' ),
		array(
			'a'      => array(
				'href'   => array(),
				'target' => array()
			),
		)
	),
	'async_webfont' => false,
	'defaults'        => clinox_default_theme_options(),
) );

/*
 * General options
 */
require_once 'general-options.php';

/*
 * Typography options
 */
require_once 'typography-options.php';

/*
 * Header options
 */
require_once 'header-options.php';

/*
 * Banner options
 */
require_once 'banner-options.php';

/*
 * Blog page options
 */
require_once 'blog-page-options.php';

/*
 * Signle Post options
 */
require_once 'single-post-options.php';


/*
 * Archive Page Options
 */
require_once 'archive-page-options.php';

/*
 * Search Page Options
 */
require_once 'search-page-options.php';

/*
 * Error 404 Page Options
 */
require_once 'error-page-options.php';

/*
 * Footer options
 */
require_once 'footer-options.php';

// Custom Css section
CSF::createSection( $clinox_theme_option, array(
	'title'  => esc_html__( 'Custom Css', 'clinox' ),
	'id'     => 'custom_css_options',
	'icon'   => 'fa fa-css3',
	'fields' => array(

		array(
			'id'       => 'clinox_custom_css',
			'type'     => 'code_editor',
			'title'    => esc_html__( 'Custom Css', 'clinox' ),
			'settings' => array(
				'theme'  => 'mbo',
				'mode'   => 'css',
			),
			'sanitize' => false,
		),
	)
) );


/*
 * Backup options
 */
CSF::createSection($clinox_theme_option, array(
	'title'  => esc_html__('Backup', 'clinox'),
	'id'     => 'backup_options',
	'icon'   => 'fa fa-window-restore',
	'fields' => array(
		array(
			'type' => 'backup',
		),
	)
));

